// remoteThread.cpp 
//
#include "stdio.h"
#include "windows.h"

int main(int argc, char ** args)
{
	int uintSize = sizeof(FARPROC);
	if (uintSize == 8)
		printf("64-bit process\n");
	else
		printf("32-bit process\n");
	if(argc<2)
	{
        printf("Please, specify process ID, where remote thread should be executed.\n");
		return -1;
	}
	int nPid = atoi(args[1]);
	if(nPid == 0)
	{
        printf("Not correctprocess pid.\n");
		return -1;
	}
	LPCTSTR kernel32 = {"kernel32.dll"};
	printf("Application tries to inject DLL into remote process with id=%d and execute 3 remote threads \n\n",nPid); 
	HANDLE handle = OpenProcess(PROCESS_ALL_ACCESS, false, nPid);
	if(handle == 0)
	{
        printf("Cannot open process with pid=%d\n", nPid);
		return -1;
	}
	
	char dllNameAndPath[512]; 
	::GetModuleFileNameA(NULL,dllNameAndPath, 512); 
    for(int ii=strlen(dllNameAndPath); ii>=0; ii--)
	{
        if(dllNameAndPath[ii] == '\\')
		{
            dllNameAndPath[ii] = '\0';
			break;
		}
	}
	strcat(dllNameAndPath,"\\win32dll.dll");
	printf("win32dll.dll full path %s\n", dllNameAndPath);
	HMODULE hmoduleLocal = ::LoadLibraryA(dllNameAndPath);
	if(hmoduleLocal==NULL)
	{
        printf("Cannot find %s\n", dllNameAndPath);
		CloseHandle(handle);
		return -1;
	}
	FARPROC openMessageBox = GetProcAddress(hmoduleLocal, "OpenMessageBox");
	unsigned long openMessageBoxOffset = (unsigned long)openMessageBox - (unsigned long)hmoduleLocal;
	::FreeLibrary(hmoduleLocal);
	HMODULE hmodule = GetModuleHandle(kernel32);
	FARPROC loadLibrary = GetProcAddress(hmodule, "LoadLibraryA");
	FARPROC freeLibrary = GetProcAddress(hmodule, "FreeLibrary");
	DWORD ThreadId;
	void*   pLibRemote;   // The address (in the remote process) where dllNameAndPath name will be copied to;
	// 1. Allocate memory in the remote process for dllNameAndPath 
	pLibRemote = ::VirtualAllocEx( handle, NULL, sizeof(dllNameAndPath)+1,
		MEM_COMMIT, PAGE_READWRITE );
	// 2. Write dllNameAndPath to the allocated memory 
	::WriteProcessMemory( handle, pLibRemote, (void*)dllNameAndPath,
		sizeof(dllNameAndPath)+1, NULL );
	// Create the 1-st remote thread to load dllNameAndPath library into remote process
	HANDLE remThread = CreateRemoteThread(handle,0,0, (LPTHREAD_START_ROUTINE)loadLibrary,
		(LPVOID)pLibRemote,
		0, &ThreadId);
	DWORD dwError = 0;
	if (remThread==NULL)
		dwError = GetLastError();
	if (dwError != 0)
	{
		printf("Failed to start the 1-st remote thread. Error: %d\n", dwError);
		CloseHandle(handle);
		return -1;
	}
	// Wait for remote the 1-st thread completion 
	::WaitForSingleObject( remThread, INFINITE );
	
	DWORD hLibModule;   // Base address of loaded module (==HMODULE);
	// Get handle of the loaded module
	BOOL result = ::GetExitCodeThread( remThread, &hLibModule );
	// Clean up 
	::CloseHandle( remThread );
	if(!result)
	{
        printf("Cannot get load %s into process with pid=%d\n", dllNameAndPath, nPid);
		CloseHandle(handle);
		return -1;
	}
	else {
		printf("%s DLL was loaded into process with pid=%d\n\n", dllNameAndPath, nPid);
	}
    // Calculate address of OpenMessageBox function in remote process
	if (uintSize==4)
		openMessageBox = (FARPROC)(hLibModule + openMessageBoxOffset);   // 32-bit process
	// Create the 2-nd remote thread to load dllNameAndPath library into remote process
	remThread = CreateRemoteThread(handle,0,0, (LPTHREAD_START_ROUTINE)openMessageBox,
		NULL,
		0, &ThreadId);
	if (remThread == NULL)
		dwError = GetLastError();
	if (dwError != 0)
	{
		printf("Failed to start the 2-nd remote thread. Error: %d\n", dwError);
		CloseHandle(handle);
		return -1;
	}
	else {
		printf("The 2-nd remote thread started\n");
	}

	// Wait for remote the 2-nd thread completion (the message box should be closed)
	::WaitForSingleObject( remThread, INFINITE );   

	printf("The 2-nd remote thread completed\n\n");
	// Create the 3-rd remote thread to unload dllNameAndPath library into remote process
	remThread = CreateRemoteThread(handle, 0, 0, (LPTHREAD_START_ROUTINE)freeLibrary,
		(LPVOID)hmoduleLocal,
		0, &ThreadId);
	if (remThread == NULL)
		dwError = GetLastError();
	if (dwError != 0)
	{
		printf("Failed to start the 3-rd remote thread. Error: %d\n", dwError);
		CloseHandle(handle);
		return -1;
	}
	// Wait for remote the 2-nd thread completion (the message box should be closed)
	::WaitForSingleObject(remThread, INFINITE);
	result = ::GetExitCodeThread(remThread, &hLibModule);
	if (result && hLibModule)
	    printf("%s DLL was unloaded from process with pid=%d\n", dllNameAndPath, nPid);

	// Clean up 
	::CloseHandle(remThread);
	CloseHandle(handle); 

	return 0;
}
